#include "bitmap.h"
#include "pixel.h"
#include "types.h"
#include <string>
#include <iostream>
#include <fstream>
#include <iomanip>
using namespace std;

void resizeSaveFile(ofstream &);
void saveToFile(ofstream &, const Bitmap &, int);

int main()
{
	ofstream dataOut;
	string picturePathName,
		   levelsPathName; 
	int fileSlot;
	bool success;
	Bitmap picture;

	// get the picture file name
	cout << "Enter the path name of the picture: ";
	getline(cin,picturePathName);

	// store the picture file
	success = picture.loadBitmap(picturePathName.c_str());
	// check for failure
	if(success == false)
	{
		cout << "Couldn't open BMP file: " << picturePathName << endl;
		return 0;
	}
	else
		cout << "Picture loaded..." << endl;

	// get the save file name
	cout << "Enter the path name of the Fill It Up save file: ";
	getline(cin,levelsPathName);
	dataOut.open(levelsPathName.c_str());
	if(!dataOut)
	{
		cout << "Couldn't open the save file." << endl;
		return 0;
	}
	// get the level slot
	cout << "Enter the level slot you wish to save to (0-63): ";
	cin  >> fileSlot;
	// check for failure
	if(fileSlot < 0 || fileSlot >= 64)
	{
		cout << "Invalid level slot.";
		return 0;
	}
	//
	resizeSaveFile(dataOut);
	// save level
	saveToFile(dataOut,picture,fileSlot);
	cout << "Save complete." << endl;

	dataOut.close();
	return 0;
}


void resizeSaveFile(ofstream & outStream)
{
	outStream.seekp(0,ios::end);
	const int END = outStream.tellp(),
			  TRUE_END = (32*32)*64,
			  EMPTY = 0;
	for(int i=END;i<TRUE_END;i++)
		outStream.write( (char*) &EMPTY, sizeof(char) );
}


void saveToFile(ofstream & outStream, const Bitmap & map, int index)
{
	COLOR pixelColor;
	const int LEN = map.getWidth() * map.getHeight(),
			  BLANK_TILE = 0,
			  START_TILE = 5,
			  RED_TILE = 1,
			  GREEN_TILE = 4,
			  BLUE_TILE = 2;

	outStream.seekp(index*32*32,ios::beg);

	for(int i=0;i<LEN;i++)
	{
		pixelColor = map.getPixel(i).getColor();
		// save starting point
		if(i == 33)
			outStream.write( (char*) &START_TILE, sizeof(char) );
		else
		{
			if(pixelColor == RED)
				outStream.write( (char*) &RED_TILE, sizeof(char) );
			else if(pixelColor == GREEN)
				outStream.write( (char*) &GREEN_TILE, sizeof(char) );
			else if(pixelColor == BLUE)
				outStream.write( (char*) &BLUE_TILE, sizeof(char) );
			else
				outStream.write( (char*) &BLANK_TILE, sizeof(char) );
		}
	}
}